% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTransactions_Account.R
\name{getTransactions_Account}
\alias{getTransactions_Account}
\title{Get an overview of transactions on the Stellar ledger.}
\usage{
getTransactions_Account(public_key, cursor = NULL, limit = NULL,
  order = "asc", data.table = TRUE)
}
\arguments{
\item{public_key}{character - your Stellar account/wallet address.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{limit}{numeric - optional, the number of records to return.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}
}
\value{
data.table (by default) or list
}
\description{
Returns all valid transactions that affected a particular account. Converts the JSON response to a list.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/transactions-for-account.html
}
\examples{
getTransactions_Account("GCO2IP3MJNUOKS4PUDI4C7LGGMQDJGXG3COYX3WSB4HHNAHKYV5YL3VC")
}
