% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{specify_priors}
\alias{specify_priors}
\title{Specify Prior Distributions for SV Models}
\usage{
specify_priors(
  mu = sv_normal(mean = 0, sd = 100),
  phi = sv_beta(shape1 = 5, shape2 = 1.5),
  sigma2 = sv_gamma(shape = 0.5, rate = 0.5),
  nu = sv_infinity(),
  rho = sv_constant(0),
  latent0_variance = "stationary",
  beta = sv_multinormal(mean = 0, sd = 10000, dim = 1)
)
}
\arguments{
\item{mu}{one of \code{sv_normal} or \code{sv_constant}}

\item{phi}{one of \code{sv_beta}, \code{sv_normal}, or \code{sv_constant}. If \code{sv_beta}, then the specified beta distribution is the prior for \code{(phi+1)/2}}

\item{sigma2}{one of \code{sv_gamma}, code{sv_inverse_gamma}, or \code{sv_constant}}

\item{nu}{one of \code{sv_infinity}, \code{sv_exponential}, or \code{sv_constant}. If \code{sv_exponential}, then the specified exponential distribution is the prior for \code{nu-2}}

\item{rho}{one of \code{sv_beta} or \code{sv_constant}. If \code{sv_beta}, then the specified beta distribution is the prior for \code{(rho+1)/2}}

\item{latent0_variance}{either the character string \code{"stationary"} or an \code{sv_constant} object.
If \code{"stationary"}, then h0 ~ N(\code{mu}, \code{sigma^2/(1-phi^2)}). If an \code{sv_constant} object with value \code{v}, then h0 ~ N(\code{mu}, \code{sigma^2/v}).
Here, N(b, B) stands for mean b and variance B}

\item{beta}{an \code{sv_multinormal} object}
}
\description{
This function gives access to a larger set of prior distributions
in case the default choice is unsatisfactory.
}
\seealso{
Other priors: 
\code{\link{sv_constant}()}
}
\concept{priors}
