% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_gains.R
\name{load_gains}
\alias{load_gains}
\title{Download and Align Gains for a Set of Tickers}
\usage{
load_gains(tickers, intercepts = NULL, slopes = NULL, from = "1950-01-01",
  to = Sys.Date(), time.scale = "daily", preto.days = NULL,
  prefrom.days = NULL, earliest = FALSE, latest = FALSE)
}
\arguments{
\item{tickers}{Character vector with ticker symbols that Yahoo! Finance 
recognizes.}

\item{intercepts}{Numeric vector of values to add to daily gains for each 
ticker.}

\item{slopes}{Numeric vector of values to multiply daily gains for each ticker 
by. Slopes are multiplied prior to adding intercepts.}

\item{from}{Date or character string (e.g. \code{"2015-01-15"}.}

\item{to}{Date or character string (e.g. \code{"2016-01-30"}).}

\item{time.scale}{Character string controlling time frame for gains. Choices 
are \code{"daily"}, \code{"monthly"}, and \code{"yearly"}.}

\item{preto.days}{Numeric value. If specified, function returns gains for 
\code{preto.days} trading days prior to \code{to}. To illustrate, to load the 
most recent 50 daily gains, you would leave \code{to} and \code{time.scale} 
as the defaults and set \code{preto.days = 50}.}

\item{prefrom.days}{Numeric value. If specified, function returns gains for 
\code{prefrom.days} trading days prior to \code{from}. Useful when you want 
to test a trading strategy starting on a particular date, but the strategy 
requires data leading up to that date (e.g. trailing beta).}

\item{earliest}{Logical value for whether to retain only the subset of 
tickers with data going the furthest back. Set to \code{FALSE} if you want 
all tickers retained and gains over their mutual lifetimes.}

\item{latest}{Logical value for whether to retain only the subset of 
tickers with data going the furthest forward, e.g. dropping funds that were 
discontinued at some point.}
}
\value{
Numeric matrix.
}
\description{
Downloads and aligns historical investment gains for specified tickers from 
Yahoo! Finance, using the \pkg{quantmod} package.
}
\details{
In aligning historical prices, dates on which not all funds have data are 
simply dropped. Messages are printed indicating which dates are dropped for 
which tickers.
}
\examples{
# Load gains for Netflix and Amazon over their mutual lifetimes
gains <- load_gains(c("NFLX", "AMZN"))


}
\references{
Ryan, J.A. and Ulrich, J.M. (2017) quantmod: Quantitative Financial Modelling 
Framework. R package version 0.4-12, 
\url{https://CRAN.R-project.org/package=quantmod}.
}
