% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopwords.R
\name{stopwords}
\alias{stopwords}
\title{Collection of stopwords in multiple languages}
\usage{
stopwords(language = "en", source = "snowball")
}
\arguments{
\item{language}{specify language of stopwords by ISO 639-1 code}

\item{source}{specify a stopwords source. To list the currently
available options, use \code{\link{stopwords_getsources}}.}
}
\value{
a character vector containing the stopwords
}
\description{
This function returns stopwords collated for Stopwords ISO library
(\url{https://github.com/stopwords-iso/stopwords-iso}).
}
\details{
The language codes for each stopword list use the two-letter ISO
code from \url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}.
For backwards compatibility, the full English names of the stopwords
from the \pkg{quanteda} package may also be used, although these are
deprecated.
}
\examples{
stopwords('en')
stopwords('de')
}
