% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_counties.R
\name{get_counties}
\alias{get_counties}
\title{Get list of electoral districts}
\usage{
get_counties(historical = FALSE)
}
\arguments{
\item{historical}{Logical. Whether or not to include historical counties.}
}
\value{
A data frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{historical_county} \tab Whether the county is historical (no longer exists) \cr
   \strong{id} \tab Id of the county \cr
   \strong{name} \tab Name of the county \cr
}
}
\description{
A function for retrieving current and/or historical electoral districts
(counties) for the Norwegian parliament.
}
\examples{
\dontrun{ 
# Request one MP by id
get_counties()

# With historical counties
get_counties(historical = TRUE)
}

}
