% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{cbind_fill}
\alias{cbind_fill}
\title{Bind DataFrames Along Columns - Filling in Missing Rows with NA}
\usage{
cbind_fill(...)
}
\arguments{
\item{...}{any combination of data.frames, matrices, or atomic vectors input
as separate arguments or a list.}
}
\value{
data.frame created by combining all the objects input together. It will always
have rownames. If colnames are not provided to the matrix-like objects, the
returned colnames can be rather esoteric since default colnaming will be revised
to ensure each colname is unique. If \code{...} is a list of vectors, then the
colnames will be the names of the list.
}
\description{
\code{cbind_fill} binds together matrix-like objects by columns. The input
objects will all internally be converted to data.frames by the generic function
\code{as.data.frame}. When some objects do not contain rows that are present in other
objects, NAs will be added to fill up the returned combined data.frame. If a matrix
doesn't have rownames, the row number is used. Note that this means that a row
with name "1" is merged with the first row of a matrix without name and so on.
The returned matrix will always have row names. Colnames are ignored.
}
\details{
\code{cbind_fill} ensures each object has unique colnames and then calls
\code{Join(by = "0")}. It is intended to be the column version of \code{plyr::rbind.fill};
it differs by allowing inputs to be matrices or vectors in addition to data.frames.
}
\examples{

# standard use
A <- data.frame("first" = 1:2, "second" = 3:4)
B <- data.frame("third" = 6:8, "fourth" = 9:11)
print(A)
print(B)
cbind_fill(A, B)

# help with unstack()
row_keep <- sample(1:nrow(InsectSprays), size = 36)
InsectSprays2 <- InsectSprays[row_keep, ]
unstacked <- unstack(InsectSprays2)
cbind_fill(unstacked)

# using rownames for binding
rownames(A) <- c("one", "two")
rownames(B) <- c("three","two","one")
print(A)
print(B)
cbind_fill(A, B)

# matrices as input
A <- matrix(1:4, 2)
B <- matrix(6:11, 3)
print(A)
print(B)
cbind_fill(A, B)

# atomic vector input
A <- data.frame("first" = 1:2, "second" = 3:4)
B <- data.frame("third" = 6:8, "fourth" = 9:11)
C <- c(12,13,14,15)
D <- c(16,17,18,19)
cbind_fill(A, B, C, D)

# same as plyr::rbind.fill, it doesn't handles well some inputs with custom rownames
# and others with default rownames
rownames(A) <- c("one", "two")
print(A)
print(B)
cbind_fill(A, B)

}
\seealso{
\code{\link{cbind_fill_matrix}}
   \code{\link[plyr]{rbind.fill}}
}
