% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{is.POSIXct}
\alias{is.POSIXct}
\title{Test for a POSIXct object}
\usage{
is.POSIXct(x)
}
\arguments{
\item{x}{an object.}
}
\value{
TRUE is \code{x} has class "POSIXct" and FALSE if \code{x} does not have class "POSIXct".
}
\description{
\code{is.POSIXct} returns whether an object is a POSIXct object (aka has class = "POSIXct").
}
\examples{
tmp <- as.POSIXlt("2021-05-24 21:49:11", tz = "America/New_York",
   format = "\%Y-\%m-\%d \%H:\%M:\%OS") # as.POSIXlt.character
time <- as.POSIXct(tmp) # as.POSIXct.POSIXlt
is.POSIXct(time)
class(time) <- append(class(time), "extra_class")
is.POSIXct(time) # classes other than POSIXct are allowed
is.POSIXct(list(time)) # returns FALSE
}
