% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMsg.R
\name{setMsg}
\alias{setMsg}
\title{setMsg}
\usage{
setMsg(..., .silent = TRUE)
}
\arguments{
\item{...}{first argument is a key and the default message, further named arguments give optional messages}

\item{.silent}{logical: should the key shown during the process}
}
\value{
returns invisibly the key
}
\description{
Sets for a key the default message and other optional messages. The first argument specifies the key and the default message.
Further named arguments give the message if the key is the same as the name,
}
\examples{
setLang("de", .domain="round")
# If ROUND=0 then getMsg returns 'Runden Sie ihr Ergebnis auf eine ganze Zahl'
# If ROUND=1 then getMsg returns 'Runden Sie ihr Ergebnis auf eine Nachkommastelle'
# Otherwise getMsg retuns 'Runden Sie ihr Ergebnis auf `r ROUND` Nachkommastellen'
setMsg(ROUND='Runden Sie ihr Ergebnis auf `r ROUND` Nachkommastellen',
       '0'='Runden Sie ihr Ergebnis auf eine ganze Zahl',
       '1'='Runden Sie ihr Ergebnis auf eine Nachkommastelle')
getMsg(ROUND=0, .lang="de", .domain="round")
getMsg(ROUND=1, .lang="de", .domain="round")     
getMsg(ROUND=2, .lang="de", .domain="round")
}
