% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evanno.R
\name{evanno}
\alias{evanno}
\title{Run Evanno Method on STRUCTURE Results}
\usage{
evanno(sr, plot = TRUE)
}
\arguments{
\item{sr}{output from a call to \code{\link{structure}}.}

\item{plot}{logical. Generate a plot of Evanno metrics.}
}
\value{
a data.frame with Evanno log-likelihood metrics for each value of K.
}
\description{
Calculate first and second order rates of changes of LnPr(K) 
  from STRUCTURE results based on Evanno et al. 2005.
}
\examples{
\dontrun{
data(msats.g)

# Run STRUCTURE
sr <- structureRun(msats, k.range = 1:4, num.k.rep = 10)

# Calculate Evanno metrics
evno <- evanno(sr)
evno
}

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Evanno, G., Regnaut, S., and J. Goudet. 2005. Detecting the 
  number of clusters of individuals using the software STRUCTURE: a 
  simulation study. Molecular Ecology 14:2611-2620.
}
\seealso{
\code{\link{structure}} \code{\link{clumpp}}
}

