% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hweTest.R
\name{hweTest}
\alias{hweTest}
\alias{hwe}
\alias{HWE}
\title{Hardy-Weinberg Equilibrium}
\usage{
hweTest(
  g,
  use.genepop = FALSE,
  which = c("Proba", "excess", "deficit"),
  enumeration = FALSE,
  dememorization = 10000,
  batches = 20,
  num.rep = 5000,
  delete.files = TRUE,
  label = NULL
)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{use.genepop}{logical. Use GENEPOP to calculate HWE p-values? 
If \code{FALSE} then \code{\link[pegas]{hw.test}} is used.}

\item{which, enumeration, dememorization, batches}{parameters for GENEPOP MCMC
HWE procedure as defined in \code{\link[genepop]{test_HW}}.}

\item{num.rep}{the number of replicates for the Monte Carlo procedure for
\code{\link[pegas]{hw.test}} or number of iterations for
\code{\link[genepop]{test_HW}}.}

\item{delete.files}{logical. Delete GENEPOP files when done?}

\item{label}{character string to use to label GENEPOP files.}
}
\value{
a vector of p-values for each locus.
}
\description{
Calculate Hardy-Weinberg equilibrium p-values.
}
\examples{
data(msats.g)
hweTest(msats.g)

}
\seealso{
\code{\link{genepop}}, \code{\link[pegas]{hw.test}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
