% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtypes.initialize.R
\name{initialize,gtypes-method}
\alias{initialize,gtypes-method}
\alias{gtypes.initialize}
\alias{initialize.gtypes}
\alias{new}
\title{\code{gtypes} Constructor}
\usage{
\S4method{initialize}{gtypes}(
  .Object,
  gen.data,
  ploidy,
  ind.names = NULL,
  sequences = NULL,
  strata = NULL,
  schemes = NULL,
  description = NULL,
  other = NULL,
  remove.sequences = FALSE
)
}
\arguments{
\item{.Object}{the object skeleton, automatically generated when 
calling \code{new}.}

\item{gen.data}{a vector, matrix, or data.frame containing the alleles 
at each locus. See below for more details.}

\item{ploidy}{ploidy of the loci.}

\item{ind.names}{an optional vector of individual sample names.}

\item{sequences}{an optional \linkS4class{multidna} 
object containing sequences represented by each locus.}

\item{strata}{an optional stratification scheme from \code{schemes}.}

\item{schemes}{an optional data.frame of stratification schemes.}

\item{description}{an optional description for the object.}

\item{other}{other optional information to include.}

\item{remove.sequences}{logical. If \code{TRUE} any sequences not referenced}
}
\description{
Create a new \linkS4class{gtypes} object using 
  \code{new("gtypes", ...)}, where '\code{...}' are arguments 
  documented below.
}
\details{
For multi-allele loci, the \code{gen.data} argument should be 
formatted such that every consecutive \code{ploidy} columns represent 
alleles of one locus. Locus names are taken from the column names in 
\code{gen.data} and should be formatted with the same root locus name, with 
unique suffixes representing alleles (e.g., for Locus1234: Locus1234.1 
and Locus1234.2, or Locus1234_A and Locus1234_B). \cr
If \code{gen.data} is a vector it is assumed to represent haplotypes of a 
haploid marker.
Sample names can be either in the rownames of \code{gen.data} or given 
separately in \code{ind.names}. If \code{ind.names} are provided, these are 
used in lieu of rownames in \code{gen.data}. 
If \code{schemes} has a column named '\code{id}', it will be used to match
to sample names in \code{gen.data}. Otherwise, if rownames are present in
\code{schemes}, a column named '\code{id}' will be created from them.
If sequences are provided in \code{sequences}, then they should be named 
and match values in the haplotype column in \code{gen.data}. If multiple 
genes are given as a \linkS4class{multidna} object, it is assumed that they
are in the same order as the columns in \code{gen.data}.
}
\seealso{
\link{df2gtypes}, \link{sequence2gtypes}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
