% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STRATVNS.R
\name{STRATVNS}
\alias{STRATVNS}
\title{Vns Algorithm}
\usage{
STRATVNS(
  X,
  L = 3,
  cvt = 0.1,
  nhmin = 2,
  maxstart = 3,
  imax = 3,
  kmax = 3,
  s = 30,
  sl = 50,
  tmax = 15,
  nsols = 20,
  cputime = 3600,
  nIterWithNoImpMax = 5,
  parallelize = TRUE
)
}
\arguments{
\item{X}{Stratification Variable}

\item{L}{Number of strata}

\item{cvt}{Target cv}

\item{nhmin}{Mininum sample size by stratum}

\item{maxstart}{Number  of iterations in multstart}

\item{imax}{Maximum Number  Iterations - VNS}

\item{kmax}{Maximum Neighborhoods  = number of cut points selected to apply shaking and local search}

\item{s}{Range of shaking procedure}

\item{sl}{Range of RVNS procedure}

\item{tmax}{Maximum number cut points in neighborhoods}

\item{nsols}{Number of initial solutions generated}

\item{cputime}{Maximum cpu time in seconds}

\item{nIterWithNoImpMax}{Maximum number of iterations without improvement in VNS}

\item{parallelize}{TRUE = Performs multiple vns calls in parallel}
}
\value{
\item{bk}{Cut points}

\item{n}{Minimum sample size}

\item{nh}{Sample size by strata}

\item{cv}{coefficient of variation}

\item{Nh}{Strata sizes}

\item{Vh}{Strata variances}

\item{cputime}{Runtime in seconds}
}
\description{
This function aims at constructing optimal
strata with an optimization algorithm based on a global
optimisation technique called Variable neighborhood search (VNS).
The optimization algorithm is applied to solve the one
dimensional case, which reduces the stratification problem
to just determining strata boundaries. Assuming that the
number L of strata and the coefficient of variation are fixed,
it is possible to produce the strata boundaries by taking
into consideration an objective function associated with
the sample size. This function determines strata boundaries
so that the elements in each stratum are more homogeneous
among themselves and produce minimum sample size applying
an integer formulation proposed by Brito et al (2015).
}
\details{
STRATVNS
}
\examples{
\dontrun{
Example1:
s<-STRATVNS(U1,L=4,cvt=0.05,nhmin=3)
Example2:
s<-STRATVNS(U15,L=3)
#'Example3:
s<-STRATVNS(U21,L=5)
Example4:
s<-STRATVNS(U1,L=3,nhmin=4)
}
}
\references{
1. Hansen, P., Mladenovi´c, N., 2001. Variable neighborhood search:
Principles and applications. European Journal of Operational
Research 130, 3, 449 – 467.

2. Brito, J.A.M., Silva, P.L.N., Semaan, G.S., Maculan, N.,
2015. Integer programming formulations applied to optimal allocation
in stratified sampling. Survey Methodology 41, 2, 427–442.
}
\author{
Leonardo de Lima, Jose Brito, Pedro Gonzalez and Breno Oliveira
}
