% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSO_Window.R
\name{DSO_Window}
\alias{DSO_Window}
\title{Sliding Window (Data Stream Operator)}
\usage{
DSO_Window(horizon = 100, lambda = 0)
}
\arguments{
\item{horizon}{the window length.}

\item{lambda}{decay factor damped window model. \code{lambda=0} means no
dampening.}
}
\value{
An object of class \code{DSO_Window} (subclass of \link{DSO}.
}
\description{
Implements a sliding window data stream operator which keeps a fixed amount
(window length) of the most recent data points of the stream.
}
\details{
If \code{lambda} is greater than 0 then the weight uses a damped window
model (Zhu and Shasha, 2002).  The weight for points in the window follows
\eqn{2^(-lambda*t)} where \eqn{t} is the age of the point.
}
\examples{

stream <- DSD_Gaussians(k=3, d=2, noise=0.05)

window <- DSO_Window(horizon=100)
window

update(window, stream, 200)
window

# plot points in window
plot(get_points(window))

}
\references{
Zhu, Y. and Shasha, D. (2002). StatStream: Statistical
Monitoring of Thousands of Data Streams in Real Time, Intl. Conference of
Very Large Data Bases (VLDB'02).
}
\seealso{
\link{DSO}
}
\author{
Michael Hahsler
}
