% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSF.R
\name{DSF}
\alias{DSF}
\alias{reset_stream.DSF}
\alias{close_stream.DSF}
\title{Data Stream Filter Base Classes}
\usage{
DSF(...)

\method{reset_stream}{DSF}(dsd, pos = 1)

\method{close_stream}{DSF}(dsd, ...)
}
\arguments{
\item{...}{Further arguments.}

\item{dsd}{a stream object of class \link{DSD}.}

\item{pos}{position in the stream.}
}
\description{
Abstract base classes for all data stream filter (DSF) classes. Data stream filters transform a data stream (\link{DSD}).
}
\details{
The \code{DSF} class cannot be instantiated, but it serve as a base
class from which other DSF classes inherit.

Data stream filters transform a \link{DSD} data stream.
DSF implementations inherit from \link{DSD} and have the same basic interface.

\code{reset_stream()} resets the source stream.

It is convenient to use the pipe (\link[magrittr:pipe]{magrittr::\%>\%}) to apply filters to data streams (see Examples section).
}
\section{Methods (by generic)}{
\itemize{
\item \code{reset_stream(DSF)}: reset the attached stream if reset is supported.

\item \code{close_stream(DSF)}: close the attached stream if close is supported.

}}
\examples{
DSF()

stream <- DSD_Gaussians(k = 3, d = 2) \%>\%
  DSF_Func(function(x) cbind(x, Xsum = x$X1 + x$X2))
stream

get_points(stream, n = 5)
}
\seealso{
Other DSF: 
\code{\link{DSF_Convolve}()},
\code{\link{DSF_Downsample}()},
\code{\link{DSF_ExponentialMA}()},
\code{\link{DSF_Func}()},
\code{\link{DSF_dplyr}()}

Other DSD: 
\code{\link{DSD_BarsAndGaussians}()},
\code{\link{DSD_Benchmark}()},
\code{\link{DSD_Cubes}()},
\code{\link{DSD_Gaussians}()},
\code{\link{DSD_MG}()},
\code{\link{DSD_Memory}()},
\code{\link{DSD_Mixture}()},
\code{\link{DSD_NULL}()},
\code{\link{DSD_ReadDB}()},
\code{\link{DSD_ReadStream}()},
\code{\link{DSD_Target}()},
\code{\link{DSD_UniformNoise}()},
\code{\link{DSD_mlbenchData}()},
\code{\link{DSD_mlbenchGenerator}()},
\code{\link{DSD}()},
\code{\link{animate_data}()},
\code{\link{close_stream}()},
\code{\link{get_points}()},
\code{\link{plot.DSD}()},
\code{\link{reset_stream}()}
}
\author{
Michael Hahsler
}
\concept{DSD}
\concept{DSF}
