% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\alias{update.DST}
\title{Update a Data Stream Mining Task Model with Points from a Stream}
\usage{
\method{update}{DST}(object, dsd, n = 1L, ...)
}
\arguments{
\item{object}{The \link{DST} object.}

\item{dsd}{A \link{DSD} object with the data stream.}

\item{n}{number of points from \code{dsd} to use for the update. Some DSD \code{dsd} accept \code{n = -1} to update with all remaining points in the stream.}

\item{...}{Additional arguments are passed on.}
}
\value{
\code{NULL} or a data.frame \code{n} rows containing update information for each data point.
}
\description{
\code{update()} for data stream mining tasks \link{DST}.
}
\examples{
set.seed(1500)
stream <- DSD_Gaussians(k = 3, d = 2, noise = .1)

dbstream <- DSC_DBSTREAM(r = .1)
assignment <- update(dbstream, stream, n = 100, assignment = TRUE)
plot(dbstream, stream, type = "both")

# DBSTREAM returns cluster assignments (see DSC_DBSTREAM).
head(assignment)
}
\seealso{
Other DST: 
\code{\link{DSAggregate}()},
\code{\link{DSClassifier}()},
\code{\link{DSC}()},
\code{\link{DSF_Scale}()},
\code{\link{DSOutlier}()},
\code{\link{DST_Runner}()},
\code{\link{DST_WriteStream}()},
\code{\link{DST}()},
\code{\link{evaluate}},
\code{\link{predict}()}
}
\author{
Michael Hahsler
}
\concept{DST}
