% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSOutlier.R
\docType{class}
\name{DSOutlier}
\alias{DSOutlier}
\title{Abstract Class for Data Stream Outlier Detectors}
\usage{
DSOutlier(...)
}
\arguments{
\item{...}{further arguments.}
}
\description{
The abstract class for all data stream outlier detectors. Cannot be
instantiated. Some \link{DSC} implementations also implement outlier/noise
detection.
}
\details{
\code{\link[=plot]{plot()}} has an extra logical argument to specify if outliers should be plotted
as red crosses.
}
\examples{
DSOutlier()

#' @examples
set.seed(1000)
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.1, noise_separation = 5)

outlier_detector <- DSOutlier_DBSTREAM(r = .05, outlier_multiplier = 2)
update(outlier_detector, stream, 500)
outlier_detector

points <- get_points(stream, 20)
points

# Outliers are predicted as class NA
predict(outlier_detector, points)

# Plot new points from the stream. Predicted outliers are marked with a red x.
plot(outlier_detector, stream)

evaluate_static(outlier_detector, stream, measure =
  c("noiseActual", "noisePredicted", "noisePrecision", "outlierJaccard"))

# use a different detector
outlier_detector2 <- DSOutlier_DStream(gridsize = .05, Cl = 0.5, outlier_multiplier = 2)
update(outlier_detector2, stream, 500)
plot(outlier_detector2, stream)

evaluate_static(outlier_detector2, stream, measure =
  c("noiseActual", "noisePredicted", "noisePrecision", "outlierJaccard"))
}
\seealso{
Other DST: 
\code{\link{DSAggregate}()},
\code{\link{DSClassifier}()},
\code{\link{DSC}()},
\code{\link{DSRegressor}()},
\code{\link{DST_SlidingWindow}()},
\code{\link{DST_WriteStream}()},
\code{\link{DST}()},
\code{\link{evaluate}},
\code{\link{predict}()},
\code{\link{stream_pipeline}},
\code{\link{update}()}

Other DSOutlier: 
\code{\link{DSC_DBSTREAM}()},
\code{\link{DSC_DStream}()}
}
\author{
Michael Hahsler
}
\concept{DSOutlier}
\concept{DST}
