% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_groups.R
\name{create_groups}
\alias{create_groups}
\title{Create Groups for CV}
\usage{
create_groups(
  formula,
  data,
  n_folds = 10,
  k_mult = NULL,
  repl = FALSE,
  grouping_formula = NULL
)
}
\arguments{
\item{formula}{A formula object that specifies the model to be fit.}

\item{data}{The data that will be separated into each group.}

\item{n_folds}{An integer value defaulted to 10 fold cross-validation. If NULL
uses Leave One Out(LOO) instead.}

\item{k_mult}{When specified, this is passed onto the \link[stressor]{cv_cluster}
to fit the data into k_groups.}

\item{repl}{A Boolean value defaulted to `FALSE`, change to `TRUE` when
replicates need to be included in the same group.}

\item{grouping_formula}{A formula object that specifies how the groups will
be gathered.}
}
\value{
A vector of the length equal to number of rows of data.frame from the
  data argument.
}
\description{
Create groups for the data by separating them either into 10 fold
 cross-validation, LOO cross-validation, or k-means grouping.
}
\details{
If `k_mult` is specified as an integer, the formula object will be
  used to help determine the features specified by the user. This will be
  passed to the \link[stressor]{cv_cluster} function, which takes a scaled
  matrix of features.

  This function is called by the \link[stressor]{cv} methods as it forms the
   groups necessary to perform the cross-validation. If you want to
   use this, it is a nice function that separates the `data` into
   groups for training and testing.
}
\examples{
 # data generation
 lm_data <- data_gen_lm(1000)

 # 10 Fold CV group
 create_groups(Y ~ ., lm_data)

 # Spatial CV
 create_groups(Y ~ ., lm_data, n_folds = 10, k_mult = 5)

 # LOO CV group
 create_groups(Y ~ ., lm_data, n_folds = NULL)
}
