% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_sine.R
\name{data_gen_sine}
\alias{data_gen_sine}
\title{Data Generation for Sinusoidal Regression}
\usage{
data_gen_sine(
  n,
  weight_mat = matrix(rnorm(15), nrow = 3, ncol = 5),
  y_int = 0,
  resp_sd = 1,
  ...
)
}
\arguments{
\item{n}{The number of observations for each parameter.}

\item{weight_mat}{The parameter coefficients, where each column represents
the coefficients and is three rows as each additive equation contains three
parameters. Defaulted to be 15 random numbers from the normal distribution.}

\item{y_int}{The y-intercept term of the additive model.}

\item{resp_sd}{The standard deviation of the epsilon term to be added for
noise.}

\item{...}{Additional arguments that are not currently implemented.}
}
\value{
A data.frame object with the n rows and the response variable with
 the number of parameters being equal to the number of columns from the
 weight matrix.
}
\description{
Creates a synthetic data set for an additive sinusoidal regression model. See
 the details section for clarification.
}
\details{
Observations are generated from the following model:
  \deqn{y = \sum_{i = 1}^n \alpha_i \ \sin{(\beta_i(x_i - \gamma_i)))} +
  y_{int}}
  Where `n` is the number of parameters to be used, \eqn{\alpha_i}'s
  are the amplitude of each sine wave, \eqn{\beta_i}'s are the periods for
  each sine wave and indirectly the weight on each \eqn{x_i}, and the
  \eqn{\gamma_i}'s are the phase shift associated with each sine wave. With
  the \eqn{y_{int}} being where it crosses the y-axis.
}
\examples{
 # Generates 10 observations
 sine_data <- data_gen_sine(10)
 sine_data
}
