% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_byperson.R
\name{create_byperson}
\alias{create_byperson}
\title{Create a data set with one gain per person}
\usage{
create_byperson(data, sg_crit1_cutoff, id_var_name, sg_var_list,
  tx_start_var_name, tx_end_var_name, sg_measure_name,
  multiple_sg_select = c("first", "last", "smalles", "largest"),
  data_is_bysg = FALSE, identify = c("sg", "sl"),
  sg_crit2_pct = 0.25, sg_crit3 = TRUE, identify_sg_1to2 = FALSE)
}
\arguments{
\item{data}{A data set in wide format including an ID variable and variables for each measurement point.}

\item{sg_crit1_cutoff}{Numeric, specifying the cut-off value to be used for the first sudden gains criterion.
If set to \code{NULL} the first criterion wont be applied.}

\item{id_var_name}{String, specifying the name of the ID variable. Each row should have a unique value.}

\item{sg_var_list}{Vector, specifying the variable names of each measurement point sequentially.}

\item{tx_start_var_name}{String, specifying the variable name of the first measurement point of the intervention.}

\item{tx_end_var_name}{String, specifying the variable name of the last measurement point of the intervention.}

\item{sg_measure_name}{String, specifying the name of the measure used to identify sudden gains/losses.}

\item{multiple_sg_select}{String, specifying which sudden gain/loss to select for this data set if more than one gain/loss was identified per case.
Options are: \code{"first"}, \code{"last"}, \code{"smallest"}, or \code{"largest"}.
The default is to select the first sudden gain (\code{"first"}) if someone experienced multiple gains.}

\item{data_is_bysg}{Logical, specifying whether the data set in the \code{data} argument is a bysg datasets created using the \code{create_bysg} function.}

\item{identify}{String, specifying whether to identify sudden gains (\code{"sg"}) or sudden losses (\code{"sl"}).
The default is to identify sudden gains (\code{"sg"}).}

\item{sg_crit2_pct}{Numeric, specifying the percentage change to be used for the second sudden gains/losses criterion.
If set to \code{NULL} the second criterion wont be applied.}

\item{sg_crit3}{If set to \code{TRUE} the third criterion will be applied automatically adjusting the critical value for missingness.
If set to \code{FALSE} the third criterion wont be applied.}

\item{identify_sg_1to2}{Logical, indicating whether to identify sudden losses from measurement point 1 to 2.
If set to TRUE, this implies that the first variable specified in \code{sg_var_list} represents a baseline measurement point, e.g. pre-intervention assessment.}
}
\value{
A wide data set with one row per case in \code{data}.
}
\description{
This function produces a wide data set with one row for each case in \code{data}.
The data set includes variables indicating whether each case experienced a sudden gain/loss or not,
values around the period of each gain/loss, and descriptives.
For cases with no sudden gain/loss the descriptive variables are coded as missing (\code{NA}).
}
\examples{
# Create byperson data set, selecting the largest gain in case of muliple gains
create_byperson(data = sgdata,
                sg_crit1_cutoff = 7,
                id_var_name = "id",
                tx_start_var_name = "bdi_s1",
                tx_end_var_name = "bdi_s12",
                sg_var_list = c("bdi_s1", "bdi_s2", "bdi_s3",
                                "bdi_s4", "bdi_s5", "bdi_s6",
                                "bdi_s7", "bdi_s8", "bdi_s9",
                                "bdi_s10", "bdi_s11", "bdi_s12"),
                sg_measure_name = "bdi",
                multiple_sg_select = "largest")
}
