\name{parse_arg}
\alias{parse_arg}
\title{
Extract Information About Data From x Argument
}
\description{
Used internally to extract information on the data being described. For instance, when calling \code{descr(exams$math)}, 
\dQuote{exams$math} is passed to it as a string, and the function will determine that \dQuote{exams} is a dataframe
and \dQuote{math} is a variable. The function will also extract subsetting information if present. 
}
\usage{
.parse_arg(arg.str)
}
\arguments{
  \item{arg.str}{
Corresponds to the x argument of the three main functions of the package, namely \code{freq()}, \code{descr()}
and \code{dfSummary()}.
}
}
\details{
The extracted attributes are attached to the objects generated by \code{freq()}, \code{descr()}
or \code{dfSummary()}.
}
\value{
A list comprised of:
\item{arg.str}{The input string}
\item{var.name}{The variable name when applicable}
\item{var.names}{The variable names when applicable}
\item{var.index}{The variable index when applicable}
\item{var.indexes}{The variable indexes when applicable}
\item{df.name}{The dataframe name when applicable}
\item{rows.subset}{The subsetting condition when applicable}
\item{data.struct}{The larger structure (list, for instance) when applicable}
}
\references{\url{https://github.com/dcomtois/summarytools}}
\author{Dominic Comtois <dominic.comtois@gmail.com>}
\keyword{ internal }
\keyword{ misc }
