% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summarytools.R
\name{print.summarytools}
\alias{print.summarytools}
\title{print.summarytools}
\usage{
\method{print}{summarytools}(x, method = "pander", file = "",
   append = FALSE, report.title = NA, table.classes = NA,
   bootstrap.css = st_options('bootstrap.css'), 
   custom.css = st_options('custom.css'), silent = FALSE, 
   footnote = st_options('footnote'), max.tbl.height = Inf,
   escape.pipe = st_options('escape.pipe'), \dots)
}
\arguments{
\item{x}{A summarytools object that was generated with \code{\link{freq}},
\code{\link{descr}}, \code{\link{ctable}} or \code{\link{dfSummary}}.}

\item{method}{One of \dQuote{pander}, \dQuote{viewer}, \dQuote{browser}, or
\dQuote{render}. For \code{print()}, default is \dQuote{pander}; for
\code{view()}, default is \dQuote{viewer}. If \dQuote{viewer} is used
outside \emph{RStudio}, \dQuote{browser} will be used instead. Use
\dQuote{render} if function is called from an Rmd document.}

\item{file}{File name to write output to. Defaults to \dQuote{}.}

\item{append}{Logical. When \code{file} argument is supplied, this indicates
whether to append output to existing file. \code{FALSE} by default.}

\item{report.title}{For \emph{html} reports, this goes into the
\code{<title>} tag. Defaults to \code{NA}, in which case \code{<title>}
will be generic.}

\item{table.classes}{Character.  Additional classes to assign to output
tables. All \emph{Bootstrap css} classes can be used. It also allows
user-defined classes (see custom.css parameter). See \emph{details}
section. \code{NA} by default.}

\item{bootstrap.css}{Logical. Set to \code{FALSE} to omit 
\emph{Bootstrap css}. \code{TRUE} by default. To change this default value
globally, see \code{\link{st_options}}.}

\item{custom.css}{Path to a user-defined \emph{.css} file. Classes defined in
this file can be used in the \code{table.classes} parameter. \code{NA} by
default. To change this default value globally, see
\code{\link{st_options}}.}

\item{silent}{Hide console messages (such as ignored variables or \code{NaN}
to \code{NA} transformations).}

\item{footnote}{footnote in \emph{html} output. When set to \dQuote{default},
this is the package name and version, R version, and current date). Has no
effect when \code{method} is \dQuote{pander}. Set to \dQuote{default},
provide your own text, or set to \code{NA} to omit. To change this default
value globally, see \code{\link{st_options}}.}

\item{max.tbl.height}{Maximum table height (in pixels) allowed in rendered
\code{dfSummary()} tables. When this argument is used, results will show up
in a \code{<div>} with the specified height and a scroll bar. Intended
to be used in \emph{Rmd} documents. Has no effect when \code{method} is 
\dQuote{pander}. \code{Inf} by default.}

\item{escape.pipe}{Logical. Set to \code{TRUE} when using \code{style='grid'}
and \code{file} argument is supplied if the intent is to generate a text
file that can be converted to other formats using \emph{Pandoc}. To change
this default value globally, see \code{\link{st_options}}.}

\item{\dots}{Additional arguments can be used to override parameters stored
as attributes in the object being printed. See \emph{Details} section.}
}
\value{
\code{NULL} when \code{method="pander"}; a file path (returned
  invisibly) when \code{method="viewer"} or \code{method="browser"}. In the
  latter case, the file path is also passed to \code{shell.exec} so the
  document is opened in default Web Browser.
}
\description{
Display \code{summarytools} objects in the console, in Web Browser or in
 \emph{RStudio}'s Viewer, or write content to file.
}
\details{
Plain ascii and \emph{rmarkdown} tables are generated via
  \code{\link[pander]{pander}}. See \emph{References} section
  for a list of all available \emph{pander} options.

The following additional arguments can be used to override
  formatting attributes stored in the object to be printed. Refer to the 
  function's documentation for details on these arguments.
   \itemize{
     \item \code{style}
     \item \code{round.digits} (except for \code{\link{dfSummary}} objects)
     \item \code{plain.ascii}
     \item \code{justify}
     \item \code{headings}
     \item \code{display.labels}
     \item \code{varnumbers}    (\code{\link{dfSummary}} objects)
     \item \code{labels.col}    (\code{\link{dfSummary}} objects)
     \item \code{graph.col}     (\code{\link{dfSummary}} objects)
     \item \code{valid.col}     (\code{\link{dfSummary}} objects)
     \item \code{na.col}         (\code{\link{dfSummary}} objects)
     \item \code{col.widths}     (\code{\link{dfSummary}} objects)
     \item \code{split.tables}
     \item \code{report.nas}    (\code{\link{freq}} objects)
     \item \code{display.type}  (\code{\link{freq}} objects)
     \item \code{missing}       (\code{\link{freq}} objects)
     \item \code{totals}        (\code{\link{freq}} and \code{\link{ctable}}
     objects)
     \item \code{caption}       (\code{\link{freq}} and \code{\link{ctable}}
     objects)
   }

The following additional arguments can be used to override
  heading elements to be printed:
   \itemize{
     \item \code{Data.frame}
     \item \code{Data.frame.label}
     \item \code{Variable}
     \item \code{Variable.label}
     \item \code{Group}
     \item \code{date}
     \item \code{Weights} (\code{\link{freq}} & \code{\link{descr}} objects)
     \item \code{Data.type} (\code{\link{freq}} objects)
     \item \code{Row.variable} (\code{\link{ctable}} objects)
     \item \code{Col.variable} (\code{\link{ctable}} objects)
   }
}
\examples{
\dontrun{
data(tobacco)
view(dfSummary(tobacco), footnote = NA)
}
data(exams)
print(freq(exams$gender), style = 'rmarkdown')
print(descr(exams), headings = FALSE)

}
\references{
\href{http://rstudio.com}{RStudio}
\href{https://github.com/dcomtois/summarytools}{Summarytools on GitHub}
\href{http://rapporter.github.io/pander/#general-options}{List of pander options on GitHub}
\href{http://getbootstrap.com/css/#tables}{Bootstrap Cascading Stylesheets}
}
\seealso{
\code{\link[pander]{pander}}
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{methods}
\keyword{print}
