% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_date_check.R
\name{multi_date_check}
\alias{multi_date_check}
\title{Check Multiple Columns for Non-Dates}
\usage{
multi_date_check(data = NULL, col_vec = NULL)
}
\arguments{
\item{data}{(dataframe) object containing at least one column of supposed dates}

\item{col_vec}{(character or numeric) vector of names or column numbers of the columns containing putative dates in the data object}
}
\value{
list of same length as \code{col_vec} with malformed dates from each column in their respective element
}
\description{
Any elements in the columns that would be changed to NA if \code{as.Date} is used are returned. This is useful for quickly identifying only the "problem" entries of ostensibly date columns that are read in as characters. This function is an extension of the \code{date_check} function in this package that deals with only a single column.
}
\examples{
# Make a dataframe to test the function
loc <- c("LTR", "GIL", "PYN", "RIN")
time <- c('2021-01-01', '2021-01-0w', '1990', '2020-10-xx')
time2 <- c('1880-08-08', '2021-01-02', '1992', '2049-11-01')
time3 <- c('2022-10-31', 'tomorrow', '1993', NA)

# Assemble our vectors into a dataframe
sites <- data.frame('site' = loc, 'first_visit' = time, "second" = time2, "third" = time3)

# Use `multi_date_check()` to return only the entries that would be lost
multi_date_check(data = sites, col_vec = c("first_visit", "second", "third"))
}
