% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_vec.R
\name{name_vec}
\alias{name_vec}
\title{Create Named Vector}
\usage{
name_vec(content, name)
}
\arguments{
\item{content}{(vector) content of vector}

\item{name}{(vector) names to assign to vector (must be in same order)}
}
\value{
(named vector) vector with contents from the \code{content} argument and names from the \code{name} argument
}
\description{
Create a named vector in a single line without either manually defining names at the outset (e.g., \verb{c("name_1" = 1, "name_2" = 2, ...}) or spending a second line to assign names to an existing vector (e.g., \code{names(vec) <- c("name_1", "name_2", ...)}). Useful in cases where you need a named vector within a pipe and don't want to break into two pipes just to define a named vector (see \code{tidyr::separate_wider_position})
}
\examples{
# Create a named vector
name_vec(content = 1:10, name = paste0("text_", 1:10))

}
