% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.survHE.R
\name{summary.survHE}
\alias{summary.survHE}
\title{Prints a summary table for the distribution the mean survival time for a
given model and data}
\usage{
\method{summary}{survHE}(object, mod = 1, t = NULL, nsim = 1000, ...)
}
\arguments{
\item{object}{a \code{survHE} object (resulting from the call to
\code{fit.models}}

\item{mod}{the model to be analysed (default = 1)}

\item{t}{the vector of times to be used in the computation. Default = NULL,
which means the observed times will be used. NB: the vector of times should
be: i) long enough so that S(t) goes to 0; and ii) dense enough so that the
approximation to the AUC is sufficiently precise}

\item{nsim}{the number of simulations from the survival curve distributions
to be used (to compute interval estimates)}

\item{\dots}{Additional options}
}
\value{
\item{mean.surv}{ A matrix with the simulated values for the mean
survival times } \item{tab}{ A summary table }
}
\description{
Calculates the mean survival time as the area under the survival curve
}
\details{
A list comprising of the following elements
}
\examples{
\dontrun{
data(bc)

mle = fit.models(formula=Surv(recyrs,censrec)~group,data=bc,
    distr="exp",method="mle")
summary(mle,nsim=100)
}

}
\references{
G Baio (2019). survHE: Survival analysis for health economic evaluation 
and cost-effectiveness modelling. Journal of Statistical Software (2020). vol 95,
14, 1-47. <doi:10.18637/jss.v095.i14>
}
\seealso{
\code{fit.models}, \code{make.surv}
}
\author{
Gianluca Baio
}
\keyword{Mean}
\keyword{Parametric}
\keyword{models}
\keyword{survival}
\keyword{time}
