% Generated by roxygen2 (4.0.1): do not edit by hand
\name{genSurv}
\alias{genSurv}
\alias{genSurvDf}
\alias{genSurvDt}
\title{Generate survival data}
\usage{
genSurvDf(b = 2L, f = 2L, c = 1L, n = 100L, pb = 0.5, nlf = 3L,
  rc = 0.8, pe = 0.5, t0 = 1L, tMax = 100L, asFactor = TRUE,
  model = FALSE, timelim = 5)

genSurvDt(b = 2L, f = 2L, c = 1L, n = 100L, pb = 0.5, nlf = 3L,
  rc = 0.8, pe = 0.5, t0 = 1L, tMax = 100L, asFactor = TRUE,
  model = TRUE, timelim = 5)
}
\arguments{
\item{b}{\dfn{binomial predictors}, the number of predictors which are
binary, i.e. limited to \eqn{0} or \eqn{1}}

\item{f}{\dfn{factors}, the number of predictors which are factors}

\item{c}{\dfn{continuous predictors}, the number of predictors which are
continuous}

\item{n}{number of observations (rows) in the data}

\item{nlf}{the number of levels in a factor}

\item{pb}{\dfn{probability for binomnial predictors}:
the probability of binomial predictors being \eqn{=1}
e.g. if \code{pb=0.3}, \eqn{30\%} will be \eqn{1}s, \eqn{70\%} will be \eqn{0}s}

\item{rc}{\dfn{ratio for continuous variables}: the ratio of levels of
continuous variables to the total number of observations \dfn{n} e.g. if
\code{rc=0.8} and \code{n=100}, it will be in the range \eqn{1-80}}

\item{pe}{\dfn{probability of event}
the probability of events (typically death/failure) occurring,
i.e. \eqn{P(e=1)}.
e.g. if \code{pe=0.6}, \eqn{60\%} will be \eqn{1}s, \eqn{40\%} will be \eqn{0}s}

\item{t0}{Lowest (starting) time}

\item{tMax}{Highest (final) time}

\item{asFactor}{if \code{asFactor=TRUE} (the default),
predictors given as \code{factor}s
will be converted to \code{factor}s in the data frame before the model
is fit}

\item{timelim}{function will timeout after \code{timelim} secs.
This is present to prevent duplication of rows.}

\item{model}{If \code{model=TRUE} will also
return a model fitted with \code{survival::coxph}.}
}
\value{
If \code{model=FALSE} (the default) a \code{data.frame} or \code{data.table} as above.
\cr
If \code{model=TRUE}: a list with the following values:
 \item{df or dt}{A \code{data.frame} (for \code{genSurvDf}) or \code{data.table}
(for \code{genSurvDt}).
Predictors are labelled \eqn{x1, x2, ..., xn}.
Outcome is \eqn{t1} (time) and \eqn{e} event (e.g. death).
Rows represent to \eqn{n} observations}
 \item{model}{A model fit with \code{survival::coxph}}
}
\description{
Generate survival data




}
\note{
\code{genSurvDt} is faster and more efficient for larger datasets.
\cr \cr
Using \code{asFactor=TRUE} with factors which have a large number of
levels (e.g. \code{nlf >30}) on large
datasets (e.g. \eqn{n >1000}) can cause
fitting to be slow.
}
\examples{
set.seed(1)
genSurvDf(model=TRUE)
genSurvDf(b=0, c=2, n=100, pe=0.7)
genSurvDf(b=1, c=0, n=1000)
genSurvDf(f=1, nlf=4, b=1, c=0, asFactor=FALSE)
set.seed(1)
genSurvDt()
genSurvDt(b=0, f=0, c=1, n=20L, pe=0.7)
}
\keyword{datagen}
\keyword{survival}

