% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survDabrowska.R
\name{survDabrowska}
\alias{survDabrowska}
\title{Computes marginal and joint survival probability estimates using Dabrowska's method.}
\usage{
survDabrowska(X, Y, deltaX, deltaY)
}
\arguments{
\item{X}{Time to event or censoring for variable \code{X}. It indicates time to event if argument \code{deltaX} is \code{1} and time to censoring if argument \code{deltaX} is \code{0}.}

\item{Y}{Time to event or censoring for variable \code{Y}. It indicates time to event if argument \code{deltaY} is \code{1} and time to censoring if argument \code{deltaY} is \code{0}.}

\item{deltaX}{Event indicator for variable \code{X}. \code{deltaX} is \code{1} if the event is observed and \code{0} if it is censored.}

\item{deltaY}{Event indicator for variable \code{Y}. \code{deltaY} is \code{1} if the event is observed and \code{0} if it is censored.}
}
\value{
A list of two elements: \code{DabrowskaEst} and \code{DabrowskaCDF}. \code{DabrowskaEst} is a matrix containing marginal and joint survival probabilities. The first column is the marginal survival probability corresponding to variable \code{X}. The first row is the marginal survival probability corresponding to variable \code{Y}. The rest of the matrix contains the joint survival probabilities. The row names of \code{DabrowskaEst} are ordered \code{X}-values. The column names of \code{DabrowskaEst} are ordered \code{Y}-values. Element \code{DabrowskaEst[1,1]} equals 1. Its row and column name is \code{'0'}. \code{DabrowskaCDF} is a matrix containing marginal and joint cumulative distribution functions (CDFs). The first row of \code{DabrowskaCDF} is the marginal CDF corresponding to variable \code{X}. The first column of \code{DabrowskaCDF} is the marginal CDF corresponding to variable \code{Y}. The row and column names of \code{DabrowskaCDF}  are the same as for \code{DabrowskaEst}.
}
\description{
The function computes marginal and joint survival probabilities for right-censored data using Dabrowska's (1988) method.
}
\details{
The function returns a list with two values: Dabrowska's estimator of the marginal and joint survival probabilities, \code{DabrowskaEst}, and its corresponding marginal and joint cumulative distribution functions (CDFs), \code{DabrowskaCDF}, based on the bivariate survival data provided by the user.
}
\examples{
X = c(0.5, 0.6, 0.6, 0.8)
Y = c(0.44, 0.77, 0.88, 0.99)
deltaX = c(1, 0, 1, 1)
deltaY = c(1, 1, 1, 1)
survDabrowska(X, Y, deltaX, deltaY)

}
\references{
Dabrowska, D. M. (1988). Kaplan–Meier estimate on the plane. The Annals of Statistics 16, 1475–1489.
}
\author{
Svetlana K Eden, \email{svetlanaeden@gmail.com}
}
\keyword{Dabrowska}
\keyword{bivariate}
\keyword{survival}
