## ---- echo = FALSE-------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>", warning = FALSE, message = FALSE, fig.align = 'center', results = 'asis', fig.show = 'hold', fig.width = 7, fig.height = 5)

## ------------------------------------------------------------------------
library(survivALL)
library(Biobase)
library(ggplot2)

data(nki_subset)

## ------------------------------------------------------------------------
xpr_vec <- exprs(nki_subset)["NM_001758", ] #expression vector for CCND1 (a marker of proliferation)

plotALL(
        measure = xpr_vec, #expression data
        srv = pData(nki_subset), #survival information
        time = "t.dmfs", #time-to-outcome
        event = "e.dmfs", #outcome type
        bs_dfr = c(), #thresholding data would go here
        measure_name = "CCND1", #our gene's name
        plot_range = "auto", #we can specify the plots y-axis range here. This makes comparing plots easier
        scale_upper = "auto", #similarly we can specify an upper limit to our pvalue colour scale
        title = "CCND1 prognostic capacity in a mixed\npopulation of invasive breast cancer samples", #plot title
        legend = "bottom", #legend position, one of 'top', 'right', 'bottom', 'left' or 'none'
        axis_text = TRUE #axis text can be removed to more easily compare multiple plots side-by-side
        )

## ------------------------------------------------------------------------
plotALL(measure = xpr_vec, 
        srv = pData(nki_subset), 
        time = "t.dmfs", 
        event = "e.dmfs", 
        bs_dfr = c(),
        measure_name = "CCND1", 
        title = "CCND1 prognostic capacity in a mixed\npopulation of invasive breast cancer samples") + 
    geom_vline(xintercept = 290, linetype = 5)

## ---- fig.width = 8------------------------------------------------------
geneset <- data.frame(refseq_id = c("NM_001758", "NM_005252", "NM_004448"), hgnc_id = c("CCND1", "FOS", "ERBB2"), stringsAsFactors = FALSE)

xpr_lst <- lapply(geneset$refseq_id, function(id){
                exprs(nki_subset)[id,]
        })
names(xpr_lst) <- geneset$hgnc_id

plot_lst <- lapply(geneset$hgnc_id, function(id){
                       plotALL(
                               measure = xpr_lst[[id]], #expression data
                               srv = pData(nki_subset), #survival information
                               time = "t.dmfs", #time-to-outcome
                               event = "e.dmfs", #outcome type
                               bs_dfr = c(), #thresholding data 
                               measure_name = id, #our gene's name
                               plot_range = c(-2.5, 2.5), #we can specify the plots y-axis range here. This makes comparing plots easier
                               scale_upper = "auto", #similarly we can specify an upper limit to our pvalue colour scale
                               title = id, #plot title
                               legend = "bottom", #legend position, one of 'top', 'right', 'bottom', 'left' or 'none'
                               axis_text = TRUE #axis text can be removed to more easily compare multiple plots side-by-side
                               )
        })

## ---- eval = FALSE-------------------------------------------------------
#  cowplot::plot_grid(plotlist = plot_lst, nrow = 1)

## ---- echo = FALSE-------------------------------------------------------
p <- cowplot::plot_grid(plotlist = plot_lst, nrow = 1)
print(p)

## ------------------------------------------------------------------------
survivall_out <- survivALL(
                           measure = xpr_vec, #expression data
                           srv = pData(nki_subset), #survival information
                           time = "t.dmfs", #time-to-outcome
                           event = "e.dmfs", #outcome type
                           bs_dfr = c(), #thresholding data
                           measure_name = "CCND1", #our gene's name
                           n_sd = 1.96 #number of standard deviations that define the threshold width - 1.96 represents 95% of random associations fall within the thresholds
                           )

## ---- eval = FALSE-------------------------------------------------------
#  head(survivall_out)

## ---- echo = FALSE-------------------------------------------------------
library(pander)
library(magrittr)
head(survivall_out) %>% pandoc.table()

## ------------------------------------------------------------------------
survivall_lst <- lapply(geneset$hgnc_id, function(id){
                            survivALL(
                                      measure = xpr_lst[[id]], #expression data
                                      srv = pData(nki_subset), #survival information
                                      time = "t.dmfs", #time-to-outcome
                                      event = "e.dmfs", #outcome type
                                      bs_dfr = c(), #thresholding data
                                      measure_name = id, #our gene's name
                                      n_sd = 1.96 #number of standard deviations that define the threshold width - 1.96 represents 95% of random associations fall within the thresholds
                                      )
                           })

survivall_dfr <- do.call(rbind, survivall_lst)

ggplot(survivall_dfr, aes(x = index, y = HR, colour = name)) + 
    geom_hline(yintercept = 0, linetype = 3) + 
    geom_point() + 
    ylim(-2.5, 2.5) + 
    ggthemes::theme_pander()

