% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{pluck_survival_analysis}
\alias{pluck_survival_analysis}
\title{Access individual components of univariate survival analysis}
\usage{
pluck_survival_analysis(result, term)
}
\arguments{
\item{result}{An object of class SurvivalAnalysisUnivariateResult
as returned by \code{\link{analyse_survival}}}

\item{term}{The item to be retrieved:
\itemize{
  \item \code{"survfit"} containing the result of the \code{\link{survfit}} function
  \item \code{"survdiff"} containing the result of the \code{\link{survdiff}} function
  \item \code{"survfit_overall"} containing the result of the \code{\link{survfit}}
        function without terms, i.e. the full group not comparing subgroups
  \item \code{"coxph"} containing the result of the \code{\link{coxph}} function
  \item \code{"p"} The log-rank p value (if \code{by} provided at least two strata)
}}
}
\value{
object as specified by \code{term}, or NULL if not contained in \code{result}
}
\description{
Allows access to the \code{\link{analyse_survival}} result object.
}
\examples{
library(magrittr)
library(dplyr)
survival::aml \%>\%
  analyse_survival(vars(time, status), x) \%>\%
  pluck_survival_analysis("p") \%>\%
  print
}
