% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extractAIC.survstan}
\alias{extractAIC.survstan}
\title{Extract AIC from a Fitted Model}
\usage{
\method{extractAIC}{survstan}(fit, scale, k = 2, ...)
}
\arguments{
\item{fit}{a fitted model of the class survstan}

\item{scale}{optional numeric specifying the scale parameter of the model. Currently only used in the "lm" method, where scale specifies the estimate of the error variance, and scale = 0 indicates that it is to be estimated by maximum likelihood.}

\item{k}{numeric specifying the ‘weight’ of the equivalent degrees of freedom part in the AIC formula.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
the ANOVA table.
}
\description{
Computes the (generalized) Akaike An Information Criterion for a fitted parametric model.
}
\examples{
\donttest{
library(survstan)
fit1 <- aftreg(Surv(futime, fustat) ~ 1, data = ovarian, baseline = "weibull", init = 0)
fit2 <- aftreg(Surv(futime, fustat) ~ rx, data = ovarian, baseline = "weibull", init = 0)
fit3 <- aftreg(Surv(futime, fustat) ~ ecog.ps + rx, data = ovarian, baseline = "weibull", init = 0)
extractAIC(fit1)
extractAIC(fit2)
extractAIC(fit3)
}

}
