% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.survstan}
\alias{residuals.survstan}
\title{residuals method for survstan models}
\usage{
\method{residuals}{survstan}(object, type = c("coxsnell", "martingale", "deviance"), ...)
}
\arguments{
\item{object}{a fitted model object of the class survstan.}

\item{type}{type of residuals desired: coxsnell (default), martingale and deviance.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a vector containing the desired residuals.
}
\description{
residuals method for survstan models
}
\details{
This function extracts the residuals, martingale residuals and deviance residuals of a survstan object.
}
\examples{
\donttest{
library(survstan)
ovarian$rx <- as.factor(ovarian$rx)
fit <- aftreg(Surv(futime, fustat) ~ age + rx, data = ovarian, baseline = "weibull", init = 0)
residuals(fit, type = "coxsnell")
residuals(fit, type = "martingale")
residuals(fit, type = "deviance")
}
}
