% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/svgPanZoom.R
\name{svgPanZoom}
\alias{svgPanZoom}
\title{Pan and Zoom R graphics}
\usage{
svgPanZoom(svg, ..., width = NULL, height = NULL, elementId = NULL)
}
\arguments{
\item{svg}{one of
\itemize{
  \item svg - SVG as XML, such as return from \code{\link[SVGAnnotation]{svgPlot}}
  \item lattice plot - trellis object, such as \code{l} in \code{l=xyplot(...)}
  \item ggplot2 plot - ggplot object, such as \code{g} in \code{g=ggplot(...) + geom_line()}
  \item filename or connection of a SVG file
}}

\item{...}{other configuration options for svg-pan-zoom.js.
See \href{https://github.com/ariutta/svg-pan-zoom#how-to-use}{svg-pan-zoom How To Use}
for a full description of the options available.  As an example to turn on
\code{controlIconsEnabled} and turn ,
do \code{svgPanZoom( ..., controlIconsEnabled = TRUE, panEnabled = FALSE )}.}

\item{width,height}{valid CSS unit (like "100\%", "400px", "auto") or a number,
which will be coerced to a string and have "px" appended}

\item{elementId}{\code{string} id for the \code{svgPanZoom} container.  Since \code{svgPanZoom}
          does not display its container, this is very unlikely to be anything other than the
          default \code{NULL}.}
}
\description{
Add panning and zooming to almost any R graphics from base graphics,
   lattice, and ggplot2 by using the JavaScript library
    \href{https://github.com/ariutta/svg-pan-zoom}{svg-pan-zoom}.
}
\examples{
#  svgPanZoom tries to be very flexible with its first argument

#  in this first example use SVG as a character string
#    this is probably the least likely use case
library(svgPanZoom)
svgPanZoom('
   <svg style="height:300px;width:300px;">
     <circle cx="60" cy="60" r="50" style="fill:none;stroke:blue;"/>
   </svg>
')


\dontrun{
library(svgPanZoom)

# first let's demonstrate a base plot
# use svgPlot for now
library(SVGAnnotation)
svgPanZoom( svgPlot( plot(1:10) ) )

svgPanZoom( svgPlot(show( xyplot( y~x, data.frame(x=1:10,y=1:10) ) ) )

# the package gridSVG is highly recommended for lattice and ggplot2
# second let's demonstrate a lattice plot
library(lattice)
svgPanZoom( xyplot( y~x, data.frame(x=1:10,y=1:10) ) )

# third with a ggplot2 plot
library(ggplot2)
svgPanZoom( ggplot( data.frame(x=1:10,y=1:10), aes(x=x,y=y) ) + geom_line() )

#Of course as a good htmlwidget should, it works with Shiny also.
library(shiny)
library(SVGAnnotation)
library(svgPanZoom)
library(ggplot2)

ui <- shinyUI(bootstrapPage(
  svgPanZoomOutput(outputId = "main_plot")
))

server = shinyServer(function(input, output) {
  output$main_plot <- renderSvgPanZoom({
    p <- ggplot() +
     geom_point(
       data=data.frame(faithful),aes(x=eruptions,y=waiting)
     ) +
     stat_density2d(
       data=data.frame(faithful)
       ,aes(x=eruptions,y=waiting ,alpha =..level..)
       ,geom="polygon") +
     scale_alpha_continuous(range=c(0.05,0.2))

     svgPanZoom(p, controlIconsEnabled = T)
  })
})

runApp(list(ui=ui,server=server))
}
}

