% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers_bats.R
\name{tidiers_bats}
\alias{tidiers_bats}
\alias{sw_tidy.bats}
\alias{sw_glance.bats}
\alias{sw_augment.bats}
\alias{sw_tidy_decomp.bats}
\title{Tidying methods for BATS and TBATS modeling of time series}
\usage{
\method{sw_tidy}{bats}(x, ...)

\method{sw_glance}{bats}(x, ...)

\method{sw_augment}{bats}(x, data = NULL, rename_index = "index",
  timetk_idx = FALSE, ...)

\method{sw_tidy_decomp}{bats}(x, timetk_idx = FALSE,
  rename_index = "index", ...)
}
\arguments{
\item{x}{An object of class "bats" or "tbats"}

\item{...}{Additional parameters (not used)}

\item{data}{Used with \code{sw_augment} only.
\code{NULL} by default which simply returns augmented columns only.
User can supply the original data, which returns the data + augmented columns.}

\item{rename_index}{Used with \code{sw_augment} only.
A string representing the name of the index generated.}

\item{timetk_idx}{Used with \code{sw_augment} and \code{sw_tidy_decomp}.
When \code{TRUE}, uses a timetk index (irregular, typically date or datetime) if present.}
}
\value{
\strong{\code{sw_tidy()}} returns one row for each model parameter,
with two columns:
\itemize{
\item \code{term}: The various parameters (lambda, alpha, gamma, etc)
\item \code{estimate}: The estimated parameter value
}

\strong{\code{sw_glance()}} returns one row with the columns
\itemize{
\item \code{model.desc}: A description of the model including the
three integer components (p, d, q) are the AR order,
the degree of differencing, and the MA order.
\item \code{sigma}: The square root of the estimated residual variance
\item \code{logLik}: The data's log-likelihood under the model
\item \code{AIC}: The Akaike Information Criterion
\item \code{BIC}: The Bayesian Information Criterion (\code{NA} for bats / tbats)
\item \code{ME}: Mean error
\item \code{RMSE}: Root mean squared error
\item \code{MAE}: Mean absolute error
\item \code{MPE}: Mean percentage error
\item \code{MAPE}: Mean absolute percentage error
\item \code{MASE}: Mean absolute scaled error
\item \code{ACF1}: Autocorrelation of errors at lag 1
}

\strong{\code{sw_augment()}} returns a tibble with the following time series attributes:
\itemize{
\item \code{index}: An index is either attempted to be extracted from the model or
a sequential index is created for plotting purposes
\item \code{.actual}: The original time series
\item \code{.fitted}: The fitted values from the model
\item \code{.resid}: The residual values from the model
}

\strong{\code{sw_tidy_decomp()}} returns a tibble with the following time series attributes:
\itemize{
\item \code{index}: An index is either attempted to be extracted from the model or
a sequential index is created for plotting purposes
\item \code{observed}: The original time series
\item \code{level}: The level component
\item \code{slope}: The slope component (Not always present)
\item \code{season}: The seasonal component (Not always present)
}
}
\description{
Tidying methods for BATS and TBATS modeling of time series
}
\examples{
library(dplyr)
library(forecast)
library(sweep)

fit_bats <- WWWusage \%>\%
    bats()

sw_tidy(fit_bats)
sw_glance(fit_bats)
sw_augment(fit_bats)

}
\seealso{
\code{\link[=bats]{bats()}}, \code{\link[=tbats]{tbats()}}
}
