% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/das_chop_section.R
\name{das_chop_section}
\alias{das_chop_section}
\alias{das_chop_section.data.frame}
\alias{das_chop_section.das_df}
\title{Chop DAS data - section}
\usage{
das_chop_section(x, ...)

\method{das_chop_section}{data.frame}(x, ...)

\method{das_chop_section}{das_df}(x, conditions, distance.method = NULL, num.cores = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{das_df},
or a data frame that can be coerced to class \code{das_df}
This data must be filtered for 'OnEffort' events;
see the Details section below}

\item{...}{ignored}

\item{conditions}{see \code{\link{das_effort}}}

\item{distance.method}{character; see \code{\link{das_effort}}.
Default is \code{NULL} since these distances should have already been calculated}

\item{num.cores}{see \code{\link{das_effort}}}
}
\value{
See \code{\link{das_chop_equallength}}. The randpicks values will all be \code{NA}
}
\description{
Chop DAS data into effort segments by continuous effort section
}
\details{
WARNING - do not call this function directly!
  It is exported for documentation purposes, but is intended for internal package use only.

  This function is simply a wrapper for \code{\link{das_chop_equallength}}.
  It calls \code{\link{das_chop_equallength}}, with \code{seg.km} set to a
  value larger than the longest continuous effort section in \code{x}.
  Thus, the effort is 'chopped' into the continuous effort sections and then summarized.

  See the Examples section for an example where the two methods give the same output.
  Note that the longest continuous effort section in the sample data is ~22km.
}
\examples{
y <- system.file("das_sample.das", package = "swfscDAS")
y.proc <- das_process(y)

y.eff1 <- das_effort(y.proc, method = "equallength", seg.km = 25, num.cores = 1)
y.eff2 <- das_effort(y.proc, method = "section", num.cores = 1)

all.equal(y.eff1, y.eff2)

}
