% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swipeR.R
\name{swipeR-shiny}
\alias{swipeR-shiny}
\alias{swipeROutput}
\alias{renderSwipeR}
\title{Shiny bindings for swipeR carousels}
\usage{
swipeROutput(outputId, width = "100\%", height = "400px")

renderSwipeR(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended}

\item{expr}{an expression that generates a \code{\link{swipeR}} carousel}

\item{env}{the environment in which to evaluate \code{expr}}

\item{quoted}{Boolean, whether \code{expr} is a quoted expression
(with \code{quote()}); this is useful if you want to save an expression
in a variable}
}
\value{
\code{swipeROutput} returns an output element that can be included
  in a Shiny UI, and \code{renderSwipeR} returns a \code{shiny.render.function}
  object that can be assigned to an output slot in a Shiny server.
}
\description{
Output and render functions for using swipeR within Shiny
  applications.
}
