% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processes.R
\name{kl.process}
\alias{kl.process}
\title{Create a Process via Karhunen-Loeve Representation}
\usage{
kl.process(
  domain = c(0, 1),
  eigen.values = 1/(2^(1:25)),
  eigen.functions = c("FOURIER", "COS", "SIN", "LEGENDRE"),
  distribution = c("GAUSSIAN", "LAPLACE", "EXPONENTIAL", "GAMMA"),
  corr = NULL
)
}
\arguments{
\item{domain}{domain of the process.}

\item{eigen.values}{vector of eigenvalues in the K-L expansion.}

\item{eigen.functions}{string that specifies the eigenfunctions in the K-L expansion.}

\item{distribution}{string specifying the distribution of FPC scores.}

\item{corr}{correlation matrix optionally specifying correlation among the random coefficients; default: NULL.}
}
\value{
a function hanlde in the form of \code{X(tObs,n)} which generates \code{n} independent trajectories observed at \code{tObs}.
}
\description{
Create a Process via Karhunen-Loeve Representation
}
\examples{
X <- kl.process()
X(regular.grid(50),25)
}
