% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELIMITERS-end_expr.R
\name{end_expr}
\alias{end_expr}
\alias{end_expr.ExprBuilder}
\title{End and evaluate expression}
\usage{
end_expr(.data, ...)

\method{end_expr}{ExprBuilder}(.data, ..., .by_ref = TRUE, .parent_env)
}
\arguments{
\item{.data}{The expression.}

\item{...}{Arguments for the specific methods.}

\item{.by_ref}{If \code{FALSE}, \code{\link[data.table:copy]{data.table::copy()}} is used before evaluation.}

\item{.parent_env}{Optionally, the \emph{enclosing} environment of the expression's evaluation
environment. Defaults to the caller environment.}
}
\description{
Finish the expression-building process and evaluate it.
}
\details{
The \link{ExprBuilder} method returns a \link[data.table:data.table-class]{data.table::data.table}.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
