% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-transmute_sd.R
\name{transmute_sd}
\alias{transmute_sd}
\alias{transmute_sd.ExprBuilder}
\alias{transmute_sd.EagerExprBuilder}
\alias{transmute_sd.data.table}
\title{Transmute subset of data}
\usage{
transmute_sd(.data, .SDcols = everything(), .how = identity, ...)

\method{transmute_sd}{ExprBuilder}(.data, .SDcols = everything(),
  .how = identity, ..., .parse = getOption("table.express.parse",
  FALSE), .chain = getOption("table.express.chain", TRUE))

\method{transmute_sd}{EagerExprBuilder}(.data, ...,
  .parent_env = rlang::caller_env())

\method{transmute_sd}{data.table}(.data, ...)
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{.SDcols}{See \link[data.table:data.table]{data.table::data.table} and the details here.}

\item{.how}{The function(s) or function call(s) that will perform the transformation. If many,
a list should be used, either with \code{list()} or \code{.()}. If the list is named, the names will be
used for the new columns' names. Lambdas specified as formulas are supported.}

\item{...}{Possibly more arguments for \emph{all} functions/calls in \code{.how}.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}

\item{.parent_env}{See \code{\link[=end_expr]{end_expr()}}}
}
\description{
Like \link{transmute-table.express} but for a single call and maybe specifying \code{.SDcols}.
}
\details{
Like \link{transmute-table.express}, this function never modifies the input by reference. This
function adds/chains a \code{select} expression that will be evaluated by \link[data.table:data.table]{data.table::data.table},
possibly specifying the helper function \code{.transmute_matching}, which is assigned to the final
expression's evaluation environment when calling \code{\link[=end_expr]{end_expr()}} (i.e., \link{ExprBuilder}'s \code{eval}
method).

Said function supports two pronouns that can be used by \code{.how} and \code{.SDcols}:
\itemize{
\item \code{.COL}: the actual values of the column.
\item \code{.COLNAME}: the name of the column currently being evaluated.
}

Additionally, lambdas specified as formulas are also supported. In those cases, \code{.x} is
equivalent to \code{.COL} and \code{.y} to \code{.COLNAME}.

Unlike a call like \code{DT[, (vars) := expr]}, \code{.SDcols} can be created dynamically with an
expression that evaluates to something that would be used in place of \code{vars} \emph{without} eagerly
using the captured \code{data.table}. See the examples here or in \link{table.express-package}.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    transmute_sd(~ grepl("^d", .y), ~ .x * 2)

data.table::as.data.table(mtcars) \%>\%
    transmute_sd(~ is.numeric(.x), ~ .x * 2)

}
