% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble.R
\name{as_tibble}
\alias{as_tibble}
\alias{as_tibble.BasicRaster}
\title{Convert a Raster to a data frame.}
\usage{
\method{as_tibble}{BasicRaster}(
  x,
  cell = TRUE,
  dim = nlayers(x) > 1L,
  value = TRUE,
  split_date = FALSE,
  xy = FALSE,
  ...
)
}
\arguments{
\item{x}{a RasterLayer, RasterStack or RasterBrick}

\item{cell}{logical to include explicit cell number}

\item{dim}{logical to include slice index}

\item{value}{logical to return the values as a column or not}

\item{split_date}{logical to split date into components}

\item{xy}{logical to include the x and y centre coordinate of each cell}

\item{...}{unused}
}
\value{
a data frame ('tbl_df'/'tibble' form)
}
\description{
Generate a data frame version of any raster object. Use the arguments
'cell', 'dim', 'split_date' and 'value' to control the columns that
are included in the output.
}
\details{
If the raster has only one layer, the slice index is not added. Use 'dim = FALSE' to not include
the slice index value.
}
\examples{
#library(tabularaster)
#library(tibble)
#as_tibble(raster::raster(volcano))
#as_tibble(raster::setZ(raster::raster(volcano), Sys.Date()), cell = TRUE)
}
