% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationBR.R
\name{AsymVarBR}
\alias{AsymVarBR}
\title{Asymptotic variance matrix for the Brown-Resnick process.}
\usage{
AsymVarBR(locations, indices, par, method, Tol = 1e-05)
}
\arguments{
\item{locations}{A \eqn{d} x 2 matrix containing the Cartesian coordinates of \eqn{d} points in the plane.}

\item{indices}{A \eqn{q} x \eqn{d} matrix containing exactly 2 ones per row, representing a pair of points from the matrix \code{locations}, and zeroes elsewhere.}

\item{par}{The parameters of the Brown-Resnick process. Either \eqn{(\alpha,\rho)} for an isotropic process or \eqn{(\alpha,\rho,\beta,c)} for an anisotropic process.}

\item{method}{Choose between "Mestimator" and "WLS".}

\item{Tol}{For "Mestimator" only. The tolerance in the numerical integration procedure. Defaults to 1e-05.}
}
\value{
A \code{q} by \code{q} matrix.
}
\description{
Computes the asymptotic variance matrix for the Brown-Resnick process, estimated using the pairwise M-estimator or the weighted least squares estimator.
}
\details{
The parameters of a The matrix \code{indices} can be either user-defined or returned from the function \code{selectGrid} with \code{cst = c(0,1)}. Calculation might be rather slow for \code{method = "Mestimator"}.
}
\examples{
locations <- cbind(rep(1:2, 3), rep(1:3, each = 2))
indices <- selectGrid(cst = c(0,1), d = 6, locations = locations, maxDistance = 1)
AsymVarBR(locations, indices, par = c(1.5,3), method = "WLS")
}
\references{
Einmahl, J.H.J., Kiriliouk, A., Krajina, A., and Segers, J. (2016). An Mestimator of spatial tail dependence. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 78(1), 275-298.

Einmahl, J.H.J., Kiriliouk, A., and Segers, J. (2016). A continuous updating weighted least squares estimator of tail dependence in high dimensions. See http://arxiv.org/abs/1601.04826.
}
\seealso{
\code{\link{selectGrid}}
}

