% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reinert.R
\name{reinSummary}
\alias{reinSummary}
\title{Summarize Reinert Clustering Results}
\usage{
reinSummary(tc, n = 10)
}
\arguments{
\item{tc}{A list returned by the \code{term_per_cluster} function. The list includes:
\itemize{
\item \code{segments}: A data frame with segments information, including \code{cluster} and \code{doc_id}.
\item \code{terms}: A data frame with terms information, including \code{cluster}, \code{sign}, \code{chi_square}, and \code{term}.
}}

\item{n}{Integer. The number of top terms (based on Chi-squared value) to include in the summary for each cluster and sign. Default is 10.}
}
\value{
A data frame summarizing the clustering results. The table includes:
\itemize{
\item \code{cluster}: The cluster ID.
\item \code{Positive terms}: The top \code{n} positive terms for each cluster, concatenated into a single string.
\item \code{Negative terms}: The top \code{n} negative terms for each cluster, concatenated into a single string.
\item \code{Most frequent document}: The document ID that appears most frequently in each cluster.
\item \code{N. of Documents per Cluster}: The number of documents in each cluster.
}
}
\description{
This function summarizes the results of the Reinert clustering algorithm, including the most frequent documents and significant terms for each cluster.
The input is the result returned by the \code{term_per_cluster} function.
}
\details{
This function performs the following steps:
\enumerate{
\item Extracts the most frequent document for each cluster.
\item Summarizes the number of documents per cluster.
\item Selects the top \code{n} terms for each cluster, separated by positive and negative signs.
\item Combines the terms and segment information into a final summary table.
}
}
\examples{

\donttest{
data(mobydick)
res <- reinert(
  x=mobydick,
  k = 10,
  term = "token",
  segment_size = 40,
  min_segment_size = 5,
  min_split_members = 10,
  cc_test = 0.3,
  tsj = 3
)

tc <- term_per_cluster(res, cutree = NULL, k=1:10, negative=FALSE)

S <- reinSummary(tc, n=10)

head(S, 10)
}

}
\seealso{
\code{\link{term_per_cluster}}, \code{\link{reinPlot}}
}
