% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{n_supertaxa_1}
\alias{n_supertaxa_1}
\title{Get number of supertaxa}
\arguments{
\item{obj}{(\code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}})}
}
\value{
\code{numeric}
}
\description{
Get number of immediate supertaxa (i.e. not supertaxa of supertaxa, etc) for
each taxon in an object of type \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}. This should
always be either 1 or 0.
\preformatted{
obj$n_supertaxa_1()
n_supertaxa_1(obj)}
}
\examples{
# Test for the presence of supertaxa containing each taxon
n_supertaxa_1(ex_taxmap)

# Filter taxa based on the presence of supertaxa
#  (this command removes all root taxa)
filter_taxa(ex_taxmap, n_supertaxa_1 > 0)

}
\seealso{
Other taxonomy data functions: 
\code{\link{classifications}()},
\code{\link{id_classifications}()},
\code{\link{is_branch}()},
\code{\link{is_internode}()},
\code{\link{is_leaf}()},
\code{\link{is_root}()},
\code{\link{is_stem}()},
\code{\link{map_data_}()},
\code{\link{map_data}()},
\code{\link{n_leaves_1}()},
\code{\link{n_leaves}()},
\code{\link{n_subtaxa_1}()},
\code{\link{n_subtaxa}()},
\code{\link{n_supertaxa}()},
\code{\link{taxon_ids}()},
\code{\link{taxon_indexes}()},
\code{\link{taxon_names}()},
\code{\link{taxon_ranks}()}
}
\concept{taxonomy data functions}
