% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{is_root}
\alias{is_root}
\title{Test if taxa are roots}
\usage{
is_root(x, subset = NULL)
}
\arguments{
\item{x}{An object containing taxonomic relationships, such as \link{taxonomy} objects.}

\item{subset}{The subset of the tree to search for roots to that subset. Can be indexes or names.}
}
\description{
Check if each taxon is a root. A root is a taxon with no supertaxon.
}
\examples{
x <- taxonomy(c('Carnivora', 'Felidae', 'Panthera', 'Panthera leo',
                'Panthera tigris', 'Ursidae', 'Ursus', 'Ursus arctos'),
              supertaxa = c(NA, 1, 2, 3, 3, 1, 6, 7))
is_root(x)
is_root(x, subset = 2:8)

}
\seealso{
Other root functions: 
\code{\link{roots}()}
}
\concept{root functions}
