% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eolid.R
\name{get_eolid}
\alias{as.data.frame.eolid}
\alias{as.eolid}
\alias{as.eolid.character}
\alias{as.eolid.data.frame}
\alias{as.eolid.eolid}
\alias{as.eolid.list}
\alias{as.eolid.numeric}
\alias{get_eolid}
\alias{get_eolid_}
\title{Get the EOL ID from Encyclopedia of Life from taxonomic names.}
\usage{
get_eolid(sciname, ask = TRUE, verbose = TRUE, key = NULL, rows = NA,
  ...)

as.eolid(x, check = TRUE)

\method{as.eolid}{eolid}(x, check = TRUE)

\method{as.eolid}{character}(x, check = TRUE)

\method{as.eolid}{list}(x, check = TRUE)

\method{as.eolid}{numeric}(x, check = TRUE)

\method{as.eolid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{eolid}(x, ...)

get_eolid_(sciname, verbose = TRUE, key = NULL, rows = NA, ...)
}
\arguments{
\item{sciname}{character; scientific name.}

\item{ask}{logical; should get_eolid be run in interactive mode?
If TRUE and more than one ID is found for the species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; If \code{TRUE} the actual taxon queried is printed
on the console.}

\item{key}{API key. passed on to \code{\link{eol_search}} and
\code{\link{eol_pages}} internally}

\item{rows}{numeric; Any number from 1 to infinity. If the default NA, all
rows are considered. Note that this function still only gives back a eolid
class object with one to many identifiers. See
\code{\link[taxize]{get_eolid_}} to get back all, or a subset, of the raw
data that you are presented during the ask process.}

\item{...}{Further args passed on to \code{\link{eol_search}}}

\item{x}{Input to \code{\link{as.eolid}}}

\item{check}{logical; Check if ID matches any existing on the DB, only
used in \code{\link{as.eolid}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.
If a taxon is not found an \code{NA} is given. If more than one identifier is found the
function asks for user input if \code{ask = TRUE}, otherwise returns \code{NA}.
If \code{ask=FALSE} and \code{rows} does not equal \code{NA}, then a data.frame is
given back, but not of the uid class, which you can't pass on to other functions
as you normally can.

Comes with the following attributes:
\itemize{
 \item \emph{match} (character) - the reason for NA, either 'not found', 'found' or
 if \code{ask = FALSE} then 'NA due to ask=FALSE')
 \item \emph{multiple_matches} (logical) - Whether multiple matches were returned by
 the data source. This can be \code{TRUE}, even if you get 1 name back because we try
 to pattern match the name to see if there's any direct matches. So sometimes
 this attribute is \code{TRUE}, as well as \code{pattern_match}, which then returns 1
 resulting name without user prompt.
 \item \emph{pattern_match} (logical) - Whether a pattern match was made. If \code{TRUE}
 then \code{multiple_matches} must be \code{TRUE}, and we found a perfect match to your
 name, ignoring case. If \code{FALSE}
}
}
\description{
Note that EOL doesn't expose an API endpoint for directly querying for EOL
taxon ID's, so we first use the function \code{\link[taxize]{eol_search}}
to find pages that deal with the species of interest, then use
\code{\link[taxize]{eol_pages}} to find the actual taxon IDs.
}
\details{
EOL is a bit odd in that they have page IDs for each taxon, but
then within that, they have taxon ids for various taxa within that page
(e.g., GBIF and NCBI each have a taxon they refer to within the
page [i.e., taxon]). And we need the taxon ids from a particular data
provider (e.g, NCBI) to do other things, like get a higher classification
tree. However, humans want the page id, not the taxon id. So, the
id returned from this function is the taxon id, not the page id. You can
get the page id for a taxon by using \code{\link{eol_search}} and
\code{\link{eol_pages}}, and the URI returned in the attributes for a
taxon will lead you to the taxon page, and the ID in the URL is the
page id.
}
\examples{
\dontrun{
get_eolid(sciname='Pinus contorta')
get_eolid(sciname='Puma concolor')

get_eolid(c("Puma concolor", "Pinus contorta"))

# specify rows to limit choices available
get_eolid('Poa annua')
get_eolid('Poa annua', rows=1)
get_eolid('Poa annua', rows=2)
get_eolid('Poa annua', rows=1:2)

# When not found
get_eolid(sciname="uaudnadndj")
get_eolid(c("Chironomus riparius", "uaudnadndj"))

# Convert a eolid without class information to a eolid class
# already a eolid, returns the same
as.eolid(get_eolid("Chironomus riparius"))
# same
as.eolid(get_eolid(c("Chironomus riparius","Pinus contorta")))
# numeric
as.eolid(24954444)
# numeric vector, length > 1
as.eolid(c(24954444,51389511,57266265))
# character
as.eolid("24954444")
# character vector, length > 1
as.eolid(c("24954444","51389511","57266265"))
# list, either numeric or character
as.eolid(list("24954444","51389511","57266265"))
## dont check, much faster
as.eolid("24954444", check=FALSE)
as.eolid(24954444, check=FALSE)
as.eolid(c("24954444","51389511","57266265"), check=FALSE)
as.eolid(list("24954444","51389511","57266265"), check=FALSE)

(out <- as.eolid(c(24954444,51389511,57266265)))
data.frame(out)
as.eolid( data.frame(out) )

# Get all data back
get_eolid_("Poa annua")
get_eolid_("Poa annua", rows=2)
get_eolid_("Poa annua", rows=1:2)
get_eolid_(c("asdfadfasd", "Pinus contorta"))
}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
\seealso{
\code{\link[taxize]{classification}}

Other taxonomic-ids: \code{\link{get_boldid}},
  \code{\link{get_colid}}, \code{\link{get_gbifid}},
  \code{\link{get_ids}}, \code{\link{get_natservid}},
  \code{\link{get_nbnid}}, \code{\link{get_tolid}},
  \code{\link{get_tpsid}}, \code{\link{get_tsn}},
  \code{\link{get_uid}}, \code{\link{get_wormsid}}
}

