% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_natservid.R
\name{get_natservid}
\alias{get_natservid}
\alias{as.natservid}
\alias{as.natservid.natservid}
\alias{as.natservid.character}
\alias{as.natservid.list}
\alias{as.natservid.numeric}
\alias{as.natservid.data.frame}
\alias{as.data.frame.natservid}
\alias{get_natservid_}
\title{Get NatureServe taxonomic ID for a taxon name}
\usage{
get_natservid(query, searchtype = "scientific", ask = TRUE,
  verbose = TRUE, rows = NaN, key = NULL, ...)

as.natservid(x, check = TRUE)

\method{as.natservid}{natservid}(x, check = TRUE)

\method{as.natservid}{character}(x, check = TRUE)

\method{as.natservid}{list}(x, check = TRUE)

\method{as.natservid}{numeric}(x, check = TRUE)

\method{as.natservid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{natservid}(x, ...)

get_natservid_(query, verbose = TRUE, rows = NaN, key = NULL, ...)
}
\arguments{
\item{query}{character; A vector of common or scientific names.}

\item{searchtype}{character; One of 'scientific' (default) or 'common'.
This doesn't affect the query to NatureServe - but rather affects what
column of data is targeted in name filtering post data request.}

\item{ask}{logical; should get_natservid be run in interactive mode?
If \code{TRUE} and more than one wormsid is found for the species, the
user is asked for input. If \code{FALSE} NA is returned for
multiple matches.}

\item{verbose}{logical; should progress be printed?}

\item{rows}{numeric; Any number from 1 to infinity. If the default NaN, all
rows are considered. Note that this function still only gives back a
natservid class object with one to many identifiers. See
\code{\link[taxize]{get_natservid_}} to get back all, or a subset, of the raw
data that you are presented during the ask process.}

\item{key}{(character) your NatureServe API key. Required. See
\strong{Authentication} below for more.}

\item{...}{Ignored}

\item{x}{Input to as.natservid}

\item{check}{logical; Check if ID matches any existing on the DB, only
used in \code{\link{as.natservid}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.
If a taxon is not found an \code{NA} is given. If more than one identifier
is found the function asks for user input if \code{ask = TRUE}, otherwise
returns \code{NA}. If \code{ask=FALSE} and \code{rows} does not equal
\code{NA}, then a data.frame is given back, but not of the uid class, which
you can't pass on to other functions as you normally can.

Comes with the following attributes:
\itemize{
 \item \emph{match} (character) - the reason for NA, either 'not found',
 'found' or if \code{ask = FALSE} then 'NA due to ask=FALSE')
 \item \emph{multiple_matches} (logical) - Whether multiple matches were
 returned by the data source. This can be \code{TRUE}, even if you get 1
 name back because we try to pattern match the name to see if there's any
 direct matches. So sometimes this attribute is \code{TRUE}, as well as
 \code{pattern_match}, which then returns 1 resulting name without user
 prompt.
 \item \emph{pattern_match} (logical) - Whether a pattern match was made.
 If \code{TRUE} then \code{multiple_matches} must be \code{TRUE}, and we
 found a perfect match to your name, ignoring case. If \code{FALSE}
 \item \emph{uri} (character) - The URI where more information can be
 read on the taxon - includes the taxonomic identifier in the URL somewhere
}
}
\description{
Get NatureServe taxonomic ID for a taxon name
}
\section{Authentication}{

Get an API key from NatureServe at
\url{https://services.natureserve.org/developer/index.jsp}.
You can pass your token in as an argument or store it one of two places:

\itemize{
  \item your .Rprofile file with an entry like
  \code{options(NatureServeKey = "your-natureserve-key")}
  \item your .Renviron file with an entry like
  \code{NATURE_SERVE_KEY=your-natureserve-key}
}

See \code{\link{Startup}} for information on how to create/find your
.Rprofile and .Renviron files
}

\examples{
\dontrun{
(x <- get_natservid("Helianthus annuus"))
attributes(x)
attr(x, "match")
attr(x, "multiple_matches")
attr(x, "pattern_match")
attr(x, "uri")

get_natservid('Gadus morhua')
get_natservid(c("Helianthus annuus", 'Gadus morhua'))

# specify rows to limit choices available
get_natservid('Ruby Quaker Moth', 'common')
get_natservid('Ruby*', 'common')
get_natservid('Ruby*', 'common', rows=1)
get_natservid('Ruby*', 'common', rows=1:2)

# When not found
get_natservid("howdy")
get_natservid(c('Gadus morhua', "howdy"))

# Convert a natservid without class information to a natservid class
# already a natservid, returns the same
as.natservid(get_natservid('Gadus morhua'))
# same
as.natservid(get_natservid(c('Gadus morhua', 'Pomatomus saltatrix')))
# character
as.natservid("ELEMENT_GLOBAL.2.101905")
# character vector, length > 1
as.natservid(c("ELEMENT_GLOBAL.2.101905", "ELEMENT_GLOBAL.2.101998"))
# list, either numeric or character
as.natservid(list("ELEMENT_GLOBAL.2.101905", "ELEMENT_GLOBAL.2.101998"))
## dont check, much faster
as.natservid("ELEMENT_GLOBAL.2.101905", check = FALSE)
as.natservid(c("ELEMENT_GLOBAL.2.101905", "ELEMENT_GLOBAL.2.101998"),
  check = FALSE)
as.natservid(list("ELEMENT_GLOBAL.2.101905", "ELEMENT_GLOBAL.2.101998"),
  check = FALSE)

(out <- as.natservid(
  c("ELEMENT_GLOBAL.2.101905", "ELEMENT_GLOBAL.2.101998")))
data.frame(out)
as.natservid( data.frame(out) )

# Get all data back
get_natservid_("Ruby*")
get_natservid_("Ruby*", rows=1:3)
}
}
\seealso{
\code{\link[taxize]{classification}}

Other taxonomic-ids: \code{\link{get_boldid}},
  \code{\link{get_colid}}, \code{\link{get_eolid}},
  \code{\link{get_gbifid}}, \code{\link{get_ids}},
  \code{\link{get_iucn}}, \code{\link{get_nbnid}},
  \code{\link{get_tolid}}, \code{\link{get_tpsid}},
  \code{\link{get_tsn}}, \code{\link{get_uid}},
  \code{\link{get_wiki}}, \code{\link{get_wormsid}}
}
