% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxlist-class.R
\docType{class}
\name{taxlist-class}
\alias{taxlist-class}
\title{An S4 class to represent taxonomic lists.}
\description{
Class for taxonomic lists including synonyms, hierarchical ranks,
parent-child relationships, taxon views and taxon traits.
}
\section{Slots}{

\describe{
\item{\code{taxonNames}}{(\code{data.frame}) Table of taxon usage names (accepted names
and synonyms).}

\item{\code{taxonRelations}}{(\code{data.frame}) Relations between concepts, accepted
names, basionyms, parents and hierarchical level.}

\item{\code{taxonTraits}}{Table of taxon traits.}

\item{\code{taxonViews}}{References used to determine the respective concept
circumscription.}
}}

\examples{
library(taxlist)

showClass("taxlist")

## Create an empty object
Splist <- new("taxlist")

}
\references{
\bold{Alvarez M, Luebert F (2018).} The taxlist package: managing plant
taxonomic lists in R. \emph{Biodiversity Data Journal} 6: e23635.
\url{https://doi.org/10.3897/bdj.6.e23635}
}
\author{
Miguel Alvarez
}
