% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissect_name.R
\name{dissect_name}
\alias{dissect_name}
\title{Dissect Scientific Names into their Elements}
\usage{
dissect_name(x, split = " ", fixed = TRUE, ...)
}
\arguments{
\item{x}{A character vector containing taxon names.}

\item{split, fixed, ...}{Arguments passed to \code{\link[=strsplit]{strsplit()}}.}
}
\value{
A character matrix with as many rows as names in the input vector.
}
\description{
Depending the degree of resolution and specific roles of nomenclature,
strings containing taxon usage names (scientific names) are constructed with
different parts.
A string with names can be consequently split into those elements, meanwhile
the number of elements will suggest the taxonomic ranks.
}
\details{
This function is using \code{\link[=strsplit]{strsplit()}} for splitting names.
Single spaces will be used to dissect names but it can be changed in the
value of argument \code{split}.
The number of columns in the resulting matrix will depend on the longest
polynomial string.
}
\examples{
Easplist <- subset(Easplist, Level == "variety", slot="relations")
Easplist <- accepted_name(Easplist)[c(1:10),"TaxonName"]

dissect_name(Easplist)

}
\seealso{
\code{\link[=strsplit]{strsplit()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
