% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_generator.R
\name{id_generator}
\alias{id_generator}
\alias{id_solver}
\title{Generate Identifiers}
\usage{
id_generator(
  len,
  minvalue = 1,
  nchar = 10,
  mode = c("numeric", "character"),
  ...
)

id_solver(insert, to, suffix = c("numeric", "character"), sep = "")
}
\arguments{
\item{len}{Numeric value indicating the length of the retrieved vector with
identifiers.}

\item{minvalue}{Numeric value indicating the minimum value in the vector of
identifiers. Used only for \code{'mode = "numeric"'}.}

\item{nchar}{Numeric value indicating the number of characters included in
the retrieved identifiers. Used only for \code{'mode = "character"'}.}

\item{mode}{Character value indicating the type of identifier created, which
is either numeric (the default) or charcter.}

\item{...}{Further parameters passed to \code{\link[=stri_rand_strings]{stri_rand_strings()}}, actually to
the argument \code{'pattern'}.}

\item{insert}{A vector (either numeric or character) containing IDs of
elements that will be inserted in a database.}

\item{to}{A vector (either numeric or character) containing IDs of elements
thar already exist in target database.}

\item{suffix}{A character vector indicating the mode used for the suffix.
Only 'numeric' or 'character' and partial matchings are accepted here.
This argument is only used for character IDs. If
\code{'suffix = "character"'}, a letter of the alphabet (vector \code{'letters'})
will be appended to duplicated IDs.}

\item{sep}{A character value used as separator between original character
ID and the appended suffix.}
}
\value{
A vector with IDs created by \code{id_generator()}, either as numeric or
character.
In the case of \code{id_solver()}, a vector, which is either identical to
\code{'insert'} (if no conflicts) or a vector witht he same properties but with
resolved IDs.
}
\description{
Creating identifiers for new elements in a database.

The function \code{id_solver()} wil compare to set of identifiers and modify the
second to avoid duplicated IDs.
}
\examples{
## Creating numeric IDs
id_generator(len = 10, minvalue = 5)

## Creating character IDs
id_generator(len = 10, mode = "character")

## Solving duplicates in numeric identifiers
id_solver(insert = c(3, 7, 5, 10), to = c(1:5))

## Solving duplicates in bibtexkeys
db_refs <- c("Alvarez2003", "Schmitz1988", "Li2023")
new_refs <- c("Alvarez2003", "Li2023", "Mueller1953", "Alvarez2003a")
any(duplicated(c(db_refs, new_refs)))

solved_refs <- id_solver(insert = new_refs, to = db_refs, suffix = "character")
solved_refs
any(duplicated(c(db_refs, solved_refs)))
}
