% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_sim_voomlike_genewise.R
\name{compute_sim_voomlike_genewise}
\alias{compute_sim_voomlike_genewise}
\title{Computing simulations results observation-wise}
\usage{
compute_sim_voomlike_genewise(counts, design, indiv, alternative = FALSE,
  fixed_eff = 0.5, fixed_eff_sd = 0, rand_eff_sd = 0.25,
  RE_indiv_sd = NULL, eps_sd = 0.05)
}
\description{
Computing simulations results observation-wise
}
\examples{

\dontrun{
rm(list=ls())
data_sims <- data_sim_voomlike(seed=1, do_gs=FALSE)
res <- compute_sim_voomlike_genewise(counts = data_sims$counts,
                                    design = data_sims$design,
                                    indiv = data_sims$indiv,
                                    alternative=TRUE,
                                    fixed_eff = 0.5,
                                    fixed_eff_sd = 0,
                                    rand_eff_sd = 0,
                                    RE_indiv_sd=NULL)
res_all <- cbind(res$res_voom, res$res_perso, res$res_noweights, res$res_DEseq, res$res_edgeR)
colnames(res_all) <- c(paste0(rep(c("asym", "perm", "camera", "roast"), 3),
                             rep(c("_voom", "_perso", "_noweights"), each=4)),
                      paste0("DESeq2_minTest_", c("exact", "approx", "CN")), "roast_edgeR")
}

}
\keyword{internal}

