% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_data-datanames.R
\name{datanames}
\alias{datanames}
\alias{datanames,teal_data-method}
\alias{datanames<-,teal_data,character-method}
\alias{datanames,qenv.error-method}
\alias{datanames<-,qenv.error,character-method}
\alias{datanames<-}
\title{Names of data sets in \code{teal_data} object}
\usage{
datanames(x)

datanames(x) <- value
}
\arguments{
\item{x}{(\code{teal_data}) object to access or modify}

\item{value}{(\code{character}) new value for \verb{@datanames}; all elements must be names of variables existing in \verb{@env}}
}
\value{
The contents of \verb{@datanames} or \code{teal_data} object with updated \verb{@datanames}.
}
\description{
Get or set the value of the \code{datanames} slot.
}
\details{
The \verb{@datanames} slot in a \code{teal_data} object specifies which of the variables stored in its environment
(the \verb{@env} slot) are data sets to be taken into consideration.
The contents of \verb{@datanames} can be specified upon creation and default to all variables in \verb{@env}.
Variables created later, which may well be data sets, are not automatically considered such.
Use this function to update the slot.
}
\examples{
td <- teal_data(iris = iris)
td <- within(td, mtcars <- mtcars)
datanames(td)

datanames(td) <- c("iris", "mtcars")
datanames(td)

}
