% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prepare_arm}
\alias{prepare_arm}
\title{Expression: Arm Preparation}
\usage{
prepare_arm(
  dataname,
  arm_var,
  ref_arm,
  comp_arm,
  compare_arm = !is.null(ref_arm),
  ref_arm_val = paste(ref_arm, collapse = "/"),
  drop = TRUE
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{ref_arm}{(\code{character})\cr the level of reference arm in case of arm comparison.}

\item{comp_arm}{(\code{character})\cr the level of comparison arm in case of arm comparison.}

\item{compare_arm}{(\code{logical})\cr triggers the comparison between study arms.}

\item{ref_arm_val}{(\code{character})\cr replacement name for the reference level.}

\item{drop}{(\code{logical})\cr drop the unused variable levels.}
}
\value{
a \code{call}
}
\description{
The function generate the standard expression for pre-processing of dataset
in teal module applications. This is especially of interest when the same
preprocessing steps needs to be applied similarly to several datasets
(e.g. \code{ADSL} and \code{ADRS}).
}
\details{
In \code{teal.modules.clinical}, the user interface includes manipulation of
the study arms. Classically: the arm variable itself (e.g. \code{ARM}, \code{ACTARM}),
the reference arm (0 or more), the comparison arm (1 or more) and the
possibility to combine comparison arms.

Note that when no arms should be compared with each other, then the produced
expression is reduced to optionally dropping non-represented levels of the arm.

When comparing arms, the pre-processing includes three steps:
\enumerate{
\item Filtering of the dataset to retain only the arms of interest (reference
and comparison).
\item Optional, if more than one arm is designated as \emph{reference} they are
combined into a single level.
\item The reference is explicitly reassigned and the non-represented levels of
arm are dropped.
}
}
\examples{
prepare_arm(
  dataname = "adrs",
  arm_var = "ARMCD",
  ref_arm = "ARM A",
  comp_arm = c("ARM B", "ARM C")
)

prepare_arm(
  dataname = "adsl",
  arm_var = "ARMCD",
  ref_arm = c("ARM B", "ARM C"),
  comp_arm = "ARM A"
)

}
